package coreservlets;

import java.util.*;

/** Bardzo prosty koszyk na zakupy.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class ItemList {
  private ArrayList items = new ArrayList();

  public synchronized void setNewItem(SimpleItem newItem) {
    if (newItem != null) {
      items.add(newItem);
    }
  }

  public synchronized String getItemTable() {
    if (items.size() == 0) {
      return("<H3>No items...</H3>");
    }
    String tableString =
      "<TABLE BORDER=1>\n" +
      "  <TR CLASS=\"COLORED\">\n" +
      "      <TH>Numer towaru\n" +
      "      <TH>Opis\n" +
      "      <TH>Koszt\n";
    for(int i=0; i<items.size(); i++) {
      SimpleItem item = (SimpleItem)items.get(i);
      tableString +=
        "  <TR><TD>" + item.getItemNum() + "\n" +
        "      <TD>" + item.getDescription() + "\n" +
        "      <TD>" + item.getCostString() + "\n";
    }
    tableString += "</TABLE>";
    return(tableString);
  }

  public synchronized String toString() {
    return("[Lista towarw: " + items.size() + " towarw.]");
  }
}
